/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesSounds;

public class PlaneSound
extends TickableSound {
    public static final Map<Integer, PlaneSound> PLAYING_FOR = Collections.synchronizedMap(new HashMap());
    private final PlaneEntity plane;
    private int fadeOut = -1;

    public PlaneSound(PlaneEntity plane) {
        super((SoundEvent)SimplePlanesSounds.PLANE_LOOP_SOUND_EVENT.get(), SoundCategory.NEUTRAL);
        this.plane = plane;
        this.field_147659_g = true;
        PLAYING_FOR.put(plane.func_145782_y(), this);
    }

    public static boolean isPlaying(int entityId) {
        if (!PLAYING_FOR.containsKey(entityId)) {
            return false;
        }
        PlaneSound sound = PLAYING_FOR.get(entityId);
        return sound != null && !sound.func_147667_k();
    }

    public static void tryToPlay(PlaneEntity planeEntity) {
        if (!PlaneSound.isPlaying(planeEntity.func_145782_y())) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PlaneSound(planeEntity));
        }
    }

    public float func_147655_f() {
        return (float)MathHelper.func_151237_a((double)((double)0.9f + this.plane.func_213322_ci().func_72433_c() / 3.0), (double)0.9f, (double)1.3f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        this.field_147660_d = this.plane.func_226277_ct_();
        this.field_147661_e = this.plane.func_226278_cu_();
        this.field_147658_f = this.plane.func_226281_cx_();
        if (this.fadeOut < 0 && (!this.plane.isPowered() || this.plane.getParked())) {
            this.fadeOut = 0;
            Map<Integer, PlaneSound> map = PLAYING_FOR;
            synchronized (map) {
                PLAYING_FOR.remove(this.plane.func_145782_y());
            }
        } else if (this.fadeOut >= 10) {
            this.func_239509_o_();
        } else if (this.fadeOut >= 0) {
            this.field_147662_b = 1.0f - (float)this.fadeOut / 10.0f;
            ++this.fadeOut;
        }
    }
}

